/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.armor;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import tcintegrations.items.modifiers.hooks.IArmorCrouchModifier;

public class FrontierCapModifier
extends Modifier
implements IArmorCrouchModifier {
    private static final UUID ATTRIBUTE_BONUS = UUID.fromString("0f65a587-22ee-4147-9dbe-79d88f078402");
    private static final float SPEED_FACTOR = 0.04f;

    @Override
    public void onCrouch(IToolStackView tool, int level, LivingEntity living) {
        if (tool.isBroken() || !living.m_20096_() || living.f_19853_.f_46443_) {
            return;
        }
        AttributeInstance attribute = living.m_21051_(Attributes.f_22279_);
        if (attribute == null) {
            return;
        }
        if (attribute.m_22111_(ATTRIBUTE_BONUS) != null) {
            attribute.m_22120_(ATTRIBUTE_BONUS);
        }
        if (!living.m_21255_()) {
            Random rand = living.m_21187_();
            float boost = (float)level * 0.04f;
            attribute.m_22118_(new AttributeModifier(ATTRIBUTE_BONUS, "tcintegrations.modifier.frontiercap", (double)boost, AttributeModifier.Operation.ADDITION));
            if (rand.nextFloat() < 0.04f) {
                ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)1, (LivingEntity)living, (EquipmentSlot)EquipmentSlot.HEAD);
            }
        }
    }

    @Override
    public void onStand(LivingEntity living) {
        AttributeInstance attribute = living.m_21051_(Attributes.f_22279_);
        if (attribute == null) {
            return;
        }
        if (attribute.m_22111_(ATTRIBUTE_BONUS) != null) {
            attribute.m_22120_(ATTRIBUTE_BONUS);
        }
    }

    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        AttributeInstance attribute;
        IToolStackView newTool;
        LivingEntity livingEntity = context.getEntity();
        if (!livingEntity.f_19853_.f_46443_ && context.getChangedSlot() == EquipmentSlot.HEAD && ((newTool = context.getReplacementTool()) == null || newTool.isBroken() || newTool.getModifierLevel((Modifier)this) != level) && (attribute = livingEntity.m_21051_(Attributes.f_22279_)) != null && attribute.m_22111_(ATTRIBUTE_BONUS) != null) {
            attribute.m_22120_(ATTRIBUTE_BONUS);
        }
    }

    @Nullable
    public <T> T getModule(Class<T> type) {
        return (T)FrontierCapModifier.tryModuleMatch(type, IArmorCrouchModifier.class, (Object)this);
    }

    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        if (player == null || key != TooltipKey.SHIFT || player.m_6047_() || player.m_6067_()) {
            this.addPercentTooltip(this.getDisplayName(), (float)level * 0.04f, tooltip);
        }
    }
}

